
/* $Id: configuration.h,v 1.3 2012/02/07 03:25:01 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/* The rest of the hardware config is in lamps.c
*/

#ifdef VERSION1
/* Version 1 hardware  (on quantel)   */
#define NUMLAMPS 5
#define NUMDRIVERS 1
#define NUMTEMP 0
#else
/* Version 2 hardware   (on lumonics)  */
#define NUMLAMPS 4
#define NUMDRIVERS 3
#define NUMTEMP 3
#endif

typedef struct configuration
{
	unsigned int magicnum;        /* If set to 0xFFFF, then the flash is erased...  if set to 0x0000, flash is programmed and needs defaults to be written, if set to MAGICNUM, then values are legal.  */

	unsigned int qswitchneg;

/* At this many clocks after the first rising edge, we will decide if all the
** rising edges have arrived, and are close enough togather.  If they are,
** we will trigger the qswitch.
** Otherwise: misfire.
*/
	unsigned int decision;

/* The max acceptable spread between the lamps  (in clocks)
*/
	unsigned int risejitter;

/* The delay from the rising edge of lamp 0 to the qswitch trigger
** in clocks
*/
	unsigned int offset[NUMDRIVERS];
	unsigned int fineoffset;   /* value given to delayline for output  */

/* Set to 1 where a lamp is implemented.
**  lamp 0 must be the OSC.  There must be an OSC...  :-)
**  lamp 4 is 24V trigger.  Thats a Quantel-ism, and optional (though untested when not pr
esent)
*/
	unsigned int lampflags;

/* Set to the desired voltage of the acopian power supply (volts)
*/
	unsigned int voltage;

/* Set to the desired current  (microamps)  
*/
	unsigned int current;

	int tempsetpoint[NUMTEMP];

} configuration;



#ifdef DEFINE
#define extern 
#else
#define extern extern
#endif

extern configuration curconfig;

#undef extern

/* after flashing firmware, will be 0
** after erase, will be 0xFFFF
**
** We will have two seperate config pages, the active one will be VALID,
** the other will be ERASED.  When we save config, we write the new config
** to the ERASED one, copying from the old one as needed, and then ERASE
** the old one.  So the active one will swap back and forth.
*/
#define CONFIGURATION_VALID 0x549D
#define CONFIGURATION_ERASED 0xFFFF

/* This is actually the number of positions on the mode switch,
** rather than how many of the above struct fits in 512 bytes.
*/
#define CONFIGURATION_NUM 6

/* Load the specified configuration into RAM curconfig
*/
void configuration_load(int num);

/* Write the RAM curconfig to the specified FLASH slot
** returns non-zero on failure
*/
int configuration_saveconfig(configuration *conf, int num);

/* Return a pointer to the specified FLASH slot.  (to show a
** config without loading it.)
*/
configuration *configuration_get(int num);

#endif
